# 배열에서 중복 번호를 찾는 플로이드 순환 탐색 알고리즘

## 문제

`n + 1` 정수를 포함하는 정수 배열이 주어지면 각 정수는 `[1, n]`을 포함한 범위에 있다. 입력 배열에 중복 숫자가 하나만 있으면 이 알고리즘은 원래 배열을 수정하지 않고 중복 숫자를 반환하고, 그렇지 않으면 `-1`을 반환한다.

## 절차


- 함수 `f(x) = arr[x]`를 사용하여 시퀀스를 구성한다.
<예시> `arr[0]`, `arr[arr[0]]`, `arr[arr[arr[0]]]`, `arr[arr[arr[arr[0]]]]`
- 시퀀스의 각각의 새로운 원소는 이전 요소의 인덱스에 있는 `arr[]`의 원소입니다.
- `x = arr[0]`부터 시작하여 원형 연결 리스트를 생성한다.
- `arr[]`에 중복 원소(최소 하나)가 포함되어 있기 때문에 `cycle`이 나타난다. 중복 값은 순환의 시작점이다.

## 시간 복잡도

$O(n)$

## 공간 복잡도

$O(1)$

## 예시

```
arr = [3, 4, 8, 5, 9, 1, 2, 6, 7, 4]  

return value = 4
```

## 구현

- [C++](https://github.com/TheAlgorithms/C-Plus-Plus/blob/master/search/floyd_cycle_detection_algo.cpp)
- [C](https://github.com/TheAlgorithms/C/blob/master/searching/floyd_cycle_detection_algorithm.c)

## 영상 URL

- [플로이드 순환 탐색 알고리즘 유튜브 영상](https://www.youtube.com/watch?v=B6smdk7pZ14)
